class CfgWeapons 
{
	class RifleCore;
	class PistolCore;
	class Pistol : PistolCore
	{
		GMJ_SA_enabled = 0;
	};
	class Rifle : RifleCore
	{
		// GMJ_SA_enabled: 1, 0
	    GMJ_SA_enabled = 0;
	    // GMJ_SA_mode: MIL, MOA
	    GMJ_SA_mode = "MOA";
	    // GMJ_SA_adjrange: { range elevation, range windage }
	    // eg. { 1.4, 1 } -> sight will adjust from elevation -0.7 to 0.7 and windage -0.5 to 0.5
	    // due to rounding errors you need to set them a tiny bit beyond the desired limit
	    GMJ_SA_adjrange[] = { 2.33335, 2.33335 };
	    // GMJ_SA_adj: { adjustment elevation, adjustment windage }
	    // eg. { 0.001, 0.002 } -> sight will be adjusted by 0.001 for elevation and 0.002 for windage
	    //GMJ_SA_adj[] = { 0.00025, 0.00025 }; // (1 / 1000) / 10
	    GMJ_SA_adj[] = { 0.00416667, 0.00416667 }; // (1 / 60) / 4
		//Rangecardpath
	};
	class AK_BASE : Rifle {};
	class AK_74 : AK_BASE
	{
	    GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.83347, 0 }; // 1000 m max elevation, no windage
	    GMJ_SA_adj[] = { 0.0572958, 0. }; // should be 100 m elevation adjustment, 1 mil instead
	};
	class AK_107_BASE;
	class AK_107_GL_kobra;	
	class AK_107_GL_pso: AK_107_GL_kobra
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.60429, 1.14592 }; // 14 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	class AK_107_pso: AK_107_BASE
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.60429, 1.14592 }; // 14 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	class AKS_BASE;
	class AKS_74_U : AKS_BASE
	{
	    GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 0.229184, 0 }; // two elevation settings, 200 m and 400 m
	    GMJ_SA_adj[] = { 0.114592, 0. };   // 400 m is +2 mils, -2 mils is nothing
	};
	class AKS_74_pso: AKS_BASE
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.60429, 1.14592 }; // 14 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	class AK_47_M: AK_BASE
	{
		GMJ_SA_enabled = 1;
		GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.100082, 0 }; // 600 m max elevation, no windage
	    GMJ_SA_adj[] = { 0.0572958, 0. }; // should be 100 m elevation adjustment, 1 mil instead
	};
		
	class M16_base;
	class M16A2 : M16_base
	{
	    // A2 elevation clicks are actually ~1.25 MOA on a 20" barrel.  The real gun shoots high at all ranges.
		// This is calibrated the way it should have been instead of the way it is, to make things easier.
	    GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 0.86667, 0.572958 }; // 26 MOA max elevation, 5 mils? windage
	    GMJ_SA_adj[] = { 0.0166667, 0.00833333 }; // 1 MOA elevation adjustment, 1/2 MOA windage adjustment
	};
	class m16a4 : M16A2
	{
	    GMJ_SA_enabled = 0;
	};
	class M16A4_GL: m16a4
	{
		GMJ_SA_enabled = 1;
	};
	class M16A4_ACG_GL: M16A4_GL
	{
		GMJ_SA_enabled = 0;
	};
	class M4A1 : M16_base 
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 0.433334, 0.572958 }; // 13 MOA max elevation, 5 mils? windage
	    GMJ_SA_adj[] = { 0.00833333, 0.00833333 }; // 1/2 MOA elevation adjustment, 1/2 MOA windage adjustment
	};
	class M4A1_Aim : M4A1
	{
	    GMJ_SA_enabled = 0; // adjustment is for zeroing only
	};
	class M4A1_RCO_GL: M4A1
	{
		GMJ_SA_enabled = 0;
		class M4_ACOG_Muzzle: M4A1
		{
			GMJ_SA_enabled = 0;
		};
		class M4_CQB_Muzzle: M4A1
		{
			GMJ_SA_enabled = 0;
		};
	};
	class M4SPR : M4A1
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 3.01, 3.01 }; // 90 MOA elevation/windage
	    GMJ_SA_adj[] = { 0.00833333, 0.00833333 }; // 1/2 MOA adjustment
	};
	class M107 : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 3.334, 3.334 }; // 100 MOA elevation/windage (possibly should be +115/-85?)
	    GMJ_SA_adj[] = { 0.00416667, 0.00416667 }; // 1/4 MOA adjustment
	};
	//Leupold Mark 4 10x40mm LR/T M3
	class M24 : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 2.501, 1.734 }; // ~75 MOA elevation / 52 MOA windage once installed
	    GMJ_SA_adj[] = { 0.0166667, 0.00833333 }; // 1 MOA elevation, 1/2 MOA windage
	};
	//Schmidt & Bender 312 x 50 PM II LP
	class M40A3 : M24 
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 1.867, 1.867 }; // ~56 MOA elevation / 56 MOA windage once installed
	    GMJ_SA_adj[] = { 0.00416667, 0.00416667 }; // 1/4 MOA adjustment
	};
	//Same properties with M40A3 has
	class ukf_l96a1 : M24
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 1.867, 1.867 }; // ~56 MOA elevation / 56 MOA windage once installed
	    GMJ_SA_adj[] = { 0.00416667, 0.00416667 }; // 1/4 MOA adjustment
	};
	class huntingrifle : M24
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.89077, 1.14592 }; // 16.5 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	//Leupold Mark 4 10x40mm LR/T M3
	class DMR : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 2.501, 1.734 }; // ~75 MOA elevation / 52 MOA windage once installed
	    GMJ_SA_adj[] = { 0.0166667, 0.00833333 }; // 1 MOA elevation, 1/2 MOA windage
	};
	class VSS_vintorez : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 2.501, 2.501 }; // ~75 MOA elevation / 75 MOA windage once installed
	    GMJ_SA_adj[] = { 0.0166667, 0.0166667 }; // 1 MOA elevation, 1 MOA windage
	};
	class SVD : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.43240, 1.14592 }; // 12.5 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	class ksvk : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 1.89077, 1.14592 }; // 16.5 mils elevation / 10 mils windage
	    GMJ_SA_adj[] = { 0.0286479, 0.0286479 }; // 1/2 mil adjustment
	};
	class PK : Rifle
	{
	    GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MIL";
	    GMJ_SA_adjrange[] = { 5.72958, 0 }; // 1500 m (50 mil?) max elevation, no windage
	    GMJ_SA_adj[] = { 0.0572958, 0 }; // should be continuous elevation changes, 1 mil instead
	};
	class M240 : Rifle
	{
	    GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 0.801, 0.572958 }; // 24 MOA? max elevation, 5 mils? windage
	    GMJ_SA_adj[] = { 0.0166667, 0.00833333 }; // 1 MOA elevation adjustment, 1/2 MOA windage adjustment
	};
	class Mk_48: M240
	{
		GMJ_SA_enabled = 0;
	};
	class M249 : Rifle
	{
		GMJ_SA_enabled = 1;
	    GMJ_SA_mode = "MOA";
	    GMJ_SA_adjrange[] = { 1.6667, 0.572958 }; // 50 MOA? max elevation, 5 mils windage
	    GMJ_SA_adj[] = { 0.0166667, 0.00833333 }; // 1 MOA elevation adjustment, 1/2 MOA windage adjustment
	};
};